﻿/*
CREATES:
	EV onPause
	() get_justPaused
	() get_justUnPaused
	() runFunc
	
REQUIRES:
	eventSystem.as
	sendEvent.as
*/


function runFunc( func ){
	return func.apply( _this, arguments.slice() );
}// runFunc()


runFunc( function(){
	if(!sendEvent)		return;
	if(!react)				return;
	
	var wasPaused = false;
	var is_justPaused = false;
	var is_justUnPaused = false;
	react.to("onEnterFrame").then = function(){
		if(isPaused === undefined)		return;		// not initialized with the LOOP system yet
		
		is_justPaused = false;
		is_justUnPaused = false;
		
		// Upon sprites being paused
		if(isPaused  &&  !wasPaused){
			wasPaused = true;
			is_justPaused = true;
			sendEvent("onPause", {value:true});
		}// if:  pausing
		
		// Upon sprites being un-paused
		else if(!isPaused  &&  wasPaused)
		{// if:  un-pausing
			wasPaused = false;
			is_justUnPaused = true;
			sendEvent("onPause", {value:false});
		}// if:  un-pausing
	}// loop() (always)
	
	
	get_justPaused = function(){
		return is_justPaused;
	}// get_justPaused()
	
	get_justUnPaused = function(){
		return is_justUnPaused;
	}// get_justUnPaused()
} );